<?php

function msp_get_slider_starter_sections () {

    $sections = array(
        array(
            'id' 	=> 'main_types',
            'title' => __( 'Slider Types', MSWP_TEXT_DOMAIN ),
            'desc'  => ''
        ),
        array(
            'id' 	=> 'masterslider_samples_group1',
            'title' => __( 'Sample Sliders', MSWP_TEXT_DOMAIN ),
            'desc'  => ''
        ),
        array(
            'id'  => 'masterslider_pro_custom_samples1',
            'title' => sprintf( __( 'Premium Sample Sliders %s', MSWP_TEXT_DOMAIN ), '( <a href="'. admin_url('admin.php?page=masterslider-setting') .'" target="_blank">'. __( 'Activation', MSWP_TEXT_DOMAIN ) .'</a> )' ),
            'desc'  => ''
        ),
        array(
            'id' 	=> 'masterslider_dynamic_group',
            'title' => __( 'Dynamic Sliders', MSWP_TEXT_DOMAIN ),
            'desc'  => ''
        )
    );

    return apply_filters( 'masterslider_starter_sections', $sections );
}


function msp_get_slider_starter_fields () {

	$wc_not_installed = msp_is_plugin_active( 'woocommerce/woocommerce.php' ) ? 'false' : 'true';

	$starters = array();

	$starters['main_types'] = array(

		array(
			'label' 	=> __( 'Custom Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'custom-slider',
			'slidertype'=> 'custom',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'true',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_custom.png'
		),
		array(
			'label' 	=> __( 'Post Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider',
			'slidertype'=> 'post',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'false',
			'disable'   => 'false',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_post.png'
		),
		array(
			'label' 	=> __( 'Flickr Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'flickr-slider',
			'slidertype'=> 'flickr',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'false',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_flickr.png'
		),
		array(
			'label' 	=> __( 'Facebook Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'facebook-slider',
			'slidertype'=> 'facebook',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'false',
			'disable'   => 'false',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_facebook.png'
		),
		array(
			'label' 	=> __( 'WooCommerce Product Slider', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'wc-product-slider',
			'slidertype'=> 'wc-product',
			'importdata'=> '',
			'image_dir' => '',
			'selected' 	=> 'false',
			'disable'   => $wc_not_installed,
			'disabled_msg' => __( 'Please install and activate WooCommerce plugin to enable this feature.', MSWP_TEXT_DOMAIN ),
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_woocommerce.png'
		)
		// ,
		// array(
		// 	'label' 	=> __( 'Instagram Slider', MSWP_TEXT_DOMAIN ),
		// 	'id' 		=> 'instagram-slider',
		// 	'slidertype'=> 'instagram',
		// 	'importdata'=> '',
		// 	'image_dir' => '',
		// 	'selected' 	=> 'false',
		// 	'disable'   => 'true',
		// 	'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/slider-types/pt_instagram.png'
		// )

	);

	$starters['masterslider_samples_group1'] = array(

		array(
			'label' 	=> __( 'Sample Slider 1', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'sample-slider1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/sample-slider-1.jpg'
		),
		array(
			'label' 	=> __( 'Sample Slider 2', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'sample-slider2',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/sample-slider-2.jpg'
		),
		array(
			'label' 	=> __( 'Sample Image Gallery', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'sample-image-gallery',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/sample-image-gallery.jpg'
		),
		array(
			'label' 	=> __( 'Image Gallery with Stack Effect', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'sample-image-gallery-stack',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/image-gallery-with-stack.jpg'
		),
		array(
			'label' 	=> __( 'Creative Agency', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'creative-agency',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/creative-agency.jpg'
		),

	);


	$starters['masterslider_dynamic_group'] = array(

		array(
			'label' 	=> __( 'Post Slider Boxed Layout', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider-boxed-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/post-slider-boxed-layout.jpg'
		),
		array(
			'label' 	=> __( 'Post Slider With Excerpt', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider-excerpt-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/post-slider-with-excerpt.jpg'
		),
		array(
			'label' 	=> __( 'Post Slider With Partial View', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider-partial-1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/post-slider-with-partial-view.jpg'
		),
		array(
			'label' 	=> __( 'Post Slider With Overlay Content', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider-overlay-left',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/post-slider-overlay-left.jpg'
		),
		array(
			'label' 	=> __( 'Post Slider With Tabs on Right', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider-tabs-right',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/post-slider-tabs-right.jpg'
		),
		array(
			'label' 	=> __( 'Post Slider With Thumb in Tabs', MSWP_TEXT_DOMAIN ),
			'id' 		=> 'post-slider-thhumb-in-tab1',
			'slidertype'=> 'custom',
			'importdata'=> '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',
			'image_dir' => '',
			'selected' 	=> '',
			'screenshot'=> MSWP_AVERTA_ADMIN_URL . '/assets/images/starters/post-slider-tabs-right.jpg'
		)
	);


	return apply_filters( 'masterslider_starter_fields', $starters );
}



function msp_get_slider_starter_field( $field_id ){
	$fields_in_sections = msp_get_slider_starter_fields();

	foreach ( $fields_in_sections as $fields_in_section ) {
		foreach ($fields_in_section as $the_field ) {
			if ( isset( $the_field['id'] ) &&  $the_field['id'] == $field_id ){
				return $the_field;
			}
		}
	}

	return null;
}
