<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package fibremarketing
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php
    $imgUrl = get_the_post_thumbnail_url(get_the_ID(),'full');
	$post_author_id = get_post_field( 'post_author', get_the_ID());
	?>
	<div class="blog_inner_wrapper">
		<div class="blog_top_part">
		    <a href="<?php the_permalink();?>"><div class="blog_post_image" style="background: url('<?php echo $imgUrl; ?>')"></div></a>
		    </div>
		<div class="blog_bottom_part">
			<div class="blog_content_section">
				<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
				<p><?php the_excerpt(); ?></p>
			</div>
			<div class="blog_meta_section listing_page">
				<div class="vc_col-md-8" style="display: flex; align-items: center;    padding-left: 0;">
					<p class="blog_date"><span></span><?php the_date(); ?></p>
					<p class="blog_author_name"><span></span><?php the_author(); ?></p>
				</div>
                <div class="vc_col-md-2 blog_author_pic">
                <img class="attachment-thumbnail size-thumbnail" src="<?php echo esc_url( get_avatar_url( $post_author_id ) ); ?>" />
                </div>
			</div>
		</div>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->
