<?php
/**
 * fibremarketing functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package fibremarketing
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

if ( ! function_exists( 'fibremarketing_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function fibremarketing_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on fibremarketing, use a find and replace
		 * to change 'fibremarketing' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'fibremarketing', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary', 'fibremarketing' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'fibremarketing_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);
		
		add_theme_support(
        	'amp',
        	array(
        		'nav_menu_dropdown' => array(
        			'sub_menu_button_class'        => 'dropdown-toggle',
        			'sub_menu_button_toggle_class' => 'toggled-on', // (optional)
        			'expand_text'                  => __( 'expand', 'domain' ),
        			'collapse_text'                => __( 'collapse', 'domain' ),
        		),
        	)
);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'fibremarketing_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function fibremarketing_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'fibremarketing_content_width', 640 );
}
add_action( 'after_setup_theme', 'fibremarketing_content_width', 0 );

add_filter('webpc_attachment_paths', function($paths) {
  $suffix = '-favicon';
  foreach ($paths as $index => $path) {
    if (!preg_match('/(.*?)' . $suffix . '((-(.*))?)\.(jpe?g|png|gif)/', basename($path))) continue;
    unset($paths[$index]);
  }
  return $paths;
});

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function fibremarketing_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'fibremarketing' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'fibremarketing' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(array(
        'name' => esc_html__('Above Footer Sidebar', 'fibremarketing'),
        'id' => 'above-footer',
        'description' => esc_html__('Above Footer Sidebar.', 'fibremarketing'),
        'before_widget' => '<aside id="%1$s" class="featured-widget widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ));
	register_sidebar(array(
        'name' => esc_html__('Footer Sidebar 1', 'fibremarketing'),
        'id' => 'sidebar-footer1',
        'description' => esc_html__('Footer sidebar #1.', 'fibremarketing'),
        'before_widget' => '<aside id="%1$s" class="footer-widget widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer Sidebar 2', 'fibremarketing'),
        'id' => 'sidebar-footer2',
        'description' => esc_html__('Footer sidebar #2.', 'fibremarketing'),
        'before_widget' => '<aside id="%1$s" class="footer-widget widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ));
    register_sidebar(array(
        'name' => esc_html__('Footer Sidebar 3', 'fibremarketing'),
        'id' => 'sidebar-footer3',
        'description' => esc_html__('Footer sidebar #3.', 'fibremarketing'),
        'before_widget' => '<aside id="%1$s" class="footer-widget widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ));
    register_sidebar(array(
        'name' => esc_html__('News Stories Sidebar', 'fibremarketing'),
        'id' => 'newssidebar',
        'description' => esc_html__('News Stories Sidebar', 'fibremarketing'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
    ));
}
add_action( 'widgets_init', 'fibremarketing_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function fibremarketing_scripts() {
	wp_enqueue_style( 'fibremarketing-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'fibremarketing-style', 'rtl', 'replace' );

    wp_enqueue_style( 'fibremarketing-icons', '/wp-content/themes/fibremarketing/ggticon.css', array(), _S_VERSION );
    
	wp_enqueue_script( 'fibremarketing-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );
	
	if(is_archive('archive.php')){
	    wp_enqueue_script('/wp-content/plugins/js_composer/assets/css/js_composer.min.css');
	}

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'fibremarketing_scripts' );

function add_file_types_to_uploads($file_types){
    $new_filetypes = array();
    $new_filetypes['svg'] = 'image/svg+xml';
    $file_types = array_merge($file_types, $new_filetypes );
    return $file_types;
}
add_filter('upload_mimes', 'add_file_types_to_uploads');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

add_filter( 'excerpt_length', function($length) {
    return 20;
} );


// Function to get archives list with limited months
function wpb_limit_archives() { 
 
$my_archives = wp_get_archives(array(
    'type'=>'yearly', 
    'limit'=>20,
    'echo'=>0
));
     
return $my_archives; 
 
} 
add_shortcode('wpb_custom_archives', 'wpb_limit_archives'); 

// Enable shortcode execution in text widget
add_filter('widget_text', 'do_shortcode'); 
add_filter( 'excerpt_length', function($length) {
    return 20;
} );

add_shortcode('case-studies','show_case_studies');
function show_case_studies($atts=[]){
ob_start();
$a = shortcode_atts( array(
        'howmany' => 3,
    ), $atts );
    $howmany = $a['howmany'];
    if($howmany){
    	$howmany = $howmany;
    }else{
    	$howmany = 3;
    }
$args = array(
	'post_type' => 'case_studies',
	'posts_per_page' => $howmany,
	'order_by' => 'date',
	'order' => 'DESC'
	);
$query = new WP_Query( $args );
?>
<div class="wpb_wrapper">
	<div class="vc_row wpb_row vc_inner vc_row-fluid mpc-row cs_main_wrapper">
<?php
while ($query->have_posts()) {
	$query->the_post();
	$imgUrl = get_the_post_thumbnail_url(get_the_ID(),'full');
	?>
		<div class="wpb_column vc_column_container vc_col-sm-4 mpc-column cs_inner_wrapper">
		    <div class="vc_column-inner">
		        <div class="wpb_wrapper">
		            <div class="ult-content-box-container ">       
		                <div class="ult-content-box">
		                    <div class="smile_icon_list_wrap ult_info_list_container ult-adjust-bottom-margin  " style="background: url(<?php echo $imgUrl; ?>); ">
		                    	<ul class="smile_icon_list top  with_bg hover_show ">
		                    	   
		                            <li class="icon_list_item" style="position:relative">
		                                 <a href="<?php the_permalink(); ?>" style="position:absolute;display:block;height:100%;width:100%;top:0;left:0;z-index:3"><span> </span>
		                                     </a>
		                                <div class="icon_description" id="Info-list-wrap-6000" style="font-size:80px;">
		                                    <h3 class="ult-responsive info-list-heading" style="position:relative"> <?php the_title(); ?></h3>
		                                    <div class="icon_description_text ult-responsive" style="color:white;">
		                                        <p ><?php the_excerpt(); ?></p>
		                                    </div>
		                                    <div class="wpb_text_column wpb_content_element top_arrow" style="position:relative">
                        						<div class="wpb_wrapper arrow_right">
		                                    		
		                                    			<img class="" src="<?php echo site_url(); ?>/wp-content/uploads/2019/11/Right-Arrow-White.png">
		                                    	</div>
		                                    </div>
		                                </div>
		                            </li>
		                        </ul>
		                        <div class="wpb_text_column wpb_content_element bottom_arrow">
                        			<div class="wpb_wrapper arrow_right">
		                                <a href="<?php the_permalink(); ?>">
		                                   	<img src="<?php echo site_url(); ?>/wp-content/uploads/2019/11/Right-Arrow-Gradient.png">
		                                </a>
		                            </div>
		                        </div>
		                    </div>
		                </div>
		            </div>
		        </div>
		    </div>
		</div>
	<?php
}
?>
	</div>
</div>
<?php
return ob_get_clean();
}

add_shortcode('case-studies-widget','show_case_studies_wdg');
function show_case_studies_wdg($atts=[]){
ob_start();
$a = shortcode_atts( array(
        'howmany' => 3,
    ), $atts );
    $howmany = $a['howmany'];
    if($howmany){
    	$howmany = $howmany;
    }else{
    	$howmany = 3;
    }
$args = array(
	'post_type' => 'case_studies',
	'posts_per_page' => $howmany,
	'order_by' => 'date',
	'order' => 'DESC'
	);
$query = new WP_Query( $args );
?>
<ul class="casestudywidgets">
<?php
while ($query->have_posts()) {
	$query->the_post();
	$imgUrl = get_the_post_thumbnail_url(get_the_ID(),'full');
	?>
	<li>
	    <a href="<?php the_permalink(); ?>">
		    <img src="<?php echo $imgUrl; ?>">
		    <!--<h4><?php the_title(); ?></h4>-->
	    </a>
    </li>
	<?php
}
?>
</ul>
<?php
return ob_get_clean();
}

add_shortcode('all-testimonials','show_testimonials');
function show_testimonials(){
ob_start();
$args = array(
	'post_type' => 'testimonials',
	'posts_per_page' => 3,
	'order_by' => 'date',
	'order' => 'DESC'
	);
$query = new WP_Query( $args );
?>
<div class="wpb_wrapper">
	<div class="vc_row wpb_row vc_inner vc_row-fluid mpc-row cs_main_wrapper">
	<?php
	while ($query->have_posts()) {
	$query->the_post();
	$imgUrl = get_the_post_thumbnail_url(get_the_ID(),'full');
	$compName = get_post_meta(get_the_ID(),'company_name',true);
	$caseURL = get_post_meta(get_the_ID(),'link_to_case_study',true);
	
	?>
	<div class="wpb_column vc_column_container vc_col-sm-4 mpc-column vc_column-inner vc_custom_1575031932793">
		<div class="wpb_wrapper testi_inner">
			<div data-id="mpc_testimonial-15dea1ebbc4b1d" class="mpc-testimonial mpc-transition mpc-testimonial--style_1 mpc-inited" style="opacity: 1;">
			    <?php if($caseURL != ""){ ?><a href="<?=$caseURL?>"> <?php } ?>
				<div class=" mpc-testimonial__thumbnail"></div>
				<div class="mpc-testimonial__content">
					<div class="mpc-testimonial__signature">
						<span></span>
					</div>
					<div class="mpc-testimonial__description">
						<p style="text-align: center;"><?php $content = get_the_content(); echo mb_strimwidth($content, 0, 240, ''); ?></p>
						<p style="text-align: center;">
						<span><strong><?php echo $compName; ?></strong></span>
						<br><strong><span style="color: #21c7d0;"><?php the_title(); ?></span></strong></p>
					</div>
				</div>
				<?php if($caseURL != ""){ ?></a> <?php } ?>
			</div>
		</div>
	</div>
	<?php
	}
	?>
	</div>
</div>
<?php
return ob_get_clean();
}


add_shortcode('fa-all-blogs','show_all_blogs');
function show_all_blogs(){
	//ob_start();
	$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	$args2 = array(
		'post_type' => 'post',
		'posts_per_page' => 5,
		'paged' => $paged,
		'order_by' => 'date',
		'order' => 'DESC'
		);
	$query2 = new WP_Query( $args2 );
		?>
		<div class="all_blogs_wrapper">
			<?php
			while ($query2->have_posts()) {
				$query2->the_post();
				$imgUrl = get_the_post_thumbnail_url(get_the_ID(),'full');
				$post_author_id = get_post_field( 'post_author', get_the_ID());
				?>
				<div class="blog_inner_wrapper">
					<div class="blog_top_part">
					    <a href="<?php the_permalink();?>"><div class="blog_post_image" style="background: url('<?php echo $imgUrl; ?>')"></div></a>
					    </div>
					<div class="blog_bottom_part">
						<div class="blog_content_section">
							<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
							<p><?php the_excerpt(); ?></p>
						</div>
						<div class="blog_meta_section listing_page">
							<div class="vc_col-md-8" style="display: flex; align-items: center;    padding-left: 0;">
								<p class="blog_date"><span></span><?php the_date(); ?></p>
								<p class="blog_author_name"><span></span><?php the_author(); ?></p>
							</div>
			<div class="vc_col-md-2 blog_author_pic">
			<img class="attachment-thumbnail size-thumbnail" src="<?php echo esc_url( get_avatar_url( $post_author_id ) ); ?>" />
			</div>
						</div>
					</div>
				</div>
				<?php
			}
			?>
		</div>
		<div class="navigation">
		    <?php  
		$big = 999999999; // need an unlikely integer
	?>
		<?php echo paginate_links( array(
			'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, get_query_var('paged') ),
			'total' => $query2->max_num_pages,				
			'prev_text'    => __('« Prev'),
			'next_text'    => __('Next »'),
		) ); ?>
		</div>
		<?php
	//return ob_get_clean();
}



add_shortcode('fa-all-blogs-new','show_all_new_blogs');
function show_all_new_blogs(){
    
    /** FEATURED **/
	$args = array(
        'post_type'  => 'post',
		'order_by' => 'date',
		'order' => 'DESC',
		'posts_per_page' => 3,
		'tag' => 'Featured'
    );
    $postslist = new WP_Query( $args );
    		?>
		<div class="news_section container featured_blogs_wrapper">
	        <div class="sectionheader">
    		    <h2>Featured</h2>
    		    <a href="https://fibre.marketing/tag/featured/">Read more ></a>
		    </div>
		    <div class="blogs">
			<?php
			while ($postslist->have_posts()) {
				$postslist->the_post();
				$imgUrl = get_the_post_thumbnail_url(get_the_ID(),'full');
				$post_author_id = get_post_field( 'post_author', get_the_ID());
				?>
				<div class="blog_inner_wrapper">
					<div class="blog_top_part">
					    <a href="<?php the_permalink();?>"><div class="blog_post_image" style="background: url('<?php echo $imgUrl; ?>')"></div></a>
					    </div>
					<div class="blog_bottom_part">
						<div class="blog_content_section">
							<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						</div>
						<div class="blog_meta_section listing_page">
						    <img class="attachment-thumbnail size-thumbnail" src="<?php echo esc_url( get_avatar_url( $post_author_id ) ); ?>" />
						    <span><?php the_author(); ?><br><?php the_date(); ?></span>
							    <span><?=do_shortcode("[rt_reading_time]");?> min read</span>
						</div>
					</div>
				</div>
				<?php
			}
			wp_reset_query();
			?>
			</div>
			<hr>
			<br>
		</div>
		<?php 
	/** END FEATURED **/
	
	/** CATEGORIES **/
	$posts_in_post_type = get_posts( array(
		'fields' => 'ids',
		'post_type' => 'post',
		'posts_per_page' => -1,
		'tag__not_in' => 116,
		'category__not_in' => array(1,25),
	) );
	$cats = get_terms( array(
		'taxonomy' => 'category',
		'hide_empty' => true,
		'object_ids' => $posts_in_post_type
	) );
	$notin = [];
	foreach($cats as $c){
	    $nwargs = array(
            'post_type'  => 'post',
    		'order_by' => 'date',
    		'order' => 'DESC',
    		'posts_per_page' => 3,
    		'category_name' => $c->slug,
		    //'tag__not_in' => 116,
		    'post__not_in' => $notin
        );
        $catpostslist = new WP_Query( $nwargs );
        		?>
    		<div class="news_section container">
    		    <div class="sectionheader">
        		    <h2><?=$c->name?></h2>
        		    <a href="<?= get_category_link( $c ) ?>">Read more ></a>
    		    </div>
    		    <div class="blogs">
    			<?php
    			while ($catpostslist->have_posts()) {
    				$catpostslist->the_post();
    				array_push($notin,get_the_ID());
    				$imgUrl = get_the_post_thumbnail_url(get_the_ID(),'full');
    				$post_author_id = get_post_field( 'post_author', get_the_ID());
    				?>
    				<div class="blog_inner_wrapper">
    					<div class="blog_top_part">
    					    <a href="<?php the_permalink();?>"><div class="blog_post_image" style="background: url('<?php echo $imgUrl; ?>')"></div></a>
    					    </div>
    					<div class="blog_bottom_part">
    						<div class="blog_content_section">
    							<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
    						</div>
    						<div class="blog_meta_section listing_page">
							    <img class="attachment-thumbnail size-thumbnail" src="<?php echo esc_url( get_avatar_url( $post_author_id ) ); ?>" />
						        <span><?php the_author(); ?><br><?php the_date(); ?></span>
							    <span><?=do_shortcode("[rt_reading_time]");?> min read</span>
    						</div>
    					</div>
    				</div>
    				<?php
    			}
    			
	wp_reset_query();
    			?>
    			</div>
    		</div>
	<?php }
}


add_shortcode('fa-all-news','show_all_news');
function show_all_news(){
	//ob_start();
	$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
	$args2 = array(
		'post_type' => 'news',
		'posts_per_page' => 5,
		'paged' => $paged,
		'order_by' => 'date',
		'order' => 'DESC'
		);
	$query2 = new WP_Query( $args2 );
		?>
		<div class="all_blogs_wrapper">
			<?php
			while ($query2->have_posts()) {
				$query2->the_post();
				$imgUrl = get_the_post_thumbnail_url(get_the_ID(),'full');
				$post_author_id = get_post_field( 'post_author', get_the_ID());
				?>
				<div class="blog_inner_wrapper">
					<div class="blog_top_part">
					    <a href="<?php the_permalink();?>"><div class="blog_post_image" style="background: url('<?php echo $imgUrl; ?>')"></div></a>
					    </div>
					<div class="blog_bottom_part">
						<div class="blog_content_section">
							<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
							<p><?php the_excerpt(); ?></p>
						</div>
						<div class="blog_meta_section listing_page">
							<div class="vc_col-md-8" style="display: flex; align-items: center;    padding-left: 0;">
								<p class="blog_date"><span></span><?php the_date(); ?></p>
								<p class="blog_author_name"><span></span><?php the_author(); ?></p>
							</div>
			<div class="vc_col-md-2 blog_author_pic">
			<img class="attachment-thumbnail size-thumbnail" src="<?php echo esc_url( get_avatar_url( $post_author_id ) ); ?>" />
			</div>
						</div>
					</div>
				</div>
				<?php
			}
			?>
		</div>
		<div class="navigation">
		    <?php  
        		$big = 999999999; // need an unlikely integer
        	?>
		<?php echo paginate_links( array(
			'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
			'format' => '?paged=%#%',
			'current' => max( 1, get_query_var('paged') ),
			'total' => $query2->max_num_pages,				
			'prev_text'    => __('« Prev'),
			'next_text'    => __('Next »'),
		) ); ?>
		</div>
		<?php
}

add_action( 'parse_query','changept' );
function changept() {
    if( is_category() && !is_admin() )
        set_query_var( 'post_type', array( 'post', 'news' ) );
    return;
}

add_filter( 'get_the_archive_title', function ($title) {    
	if ( is_category() ) {    
			$title = single_cat_title( '', false );    
		} elseif ( is_tag() ) {    
			$title = single_tag_title( '', false );    
		} elseif ( is_author() ) {    
			$title = '<span class="vcard">' . get_the_author() . '</span>' ;    
		} elseif ( is_tax() ) { //for custom post types
			$title = sprintf( __( '%1$s' ), single_term_title( '', false ) );
		} elseif (is_post_type_archive()) {
			$title = post_type_archive_title( '', false );
		}
	return $title;    
});

// Register and load the widget
function fib_load_widget() {
    register_widget( 'fib_recnewsblock_widget' );
}
add_action( 'widgets_init', 'fib_load_widget' );
 
// Creating the widget 
class fib_recnewsblock_widget extends WP_Widget {
 
	function __construct() {
		parent::__construct(

		// Base ID of your widget
		'fib_recnewsblock_widget', 

		// Widget name will appear in UI
		__('Recent News Stories Widget', 'fib_recnewsblock_widget_domain'), 

		// Widget description
		array( 'description' => __( 'Recent News Stories Widget', 'fib_recnewsblock_widget_domain' ), ) 
		);
	}

	// Creating widget front-end 
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );
		$postnum = $instance['postnum'];
		
		$args2 = array(
    		'post_type' => 'news',
    		'posts_per_page' => $postnum,
    		'paged' => $paged,
    		'order_by' => 'date',
    		'order' => 'DESC'
    		);
    	$query2 = new WP_Query( $args2 );
		?>
		<section class="widget widget_recent_entries">
		    <h2 class="widget-title"><?= $title ?></h2>
		    <ul>
		    <?php
		        while ($query2->have_posts()) {
				    $query2->the_post();
				    ?>
				    <li>
				        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			        </li>
				    <?php
		        }
		    ?>
		    </ul>
	    </section>
		<?php
	}
         
	// Widget Backend 
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'New Title', 'fib_recnewsblock_widget_domain' );
		}
		if ( isset( $instance[ 'postnum' ] ) ) {
			$postnum = $instance[ 'postnum' ];
		}
		else {
			$postnum = __( '5', 'fib_recnewsblock_widget_domain' );
		}
	// Widget admin form
	?>
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id( 'postnum' ); ?>"><?php _e( 'Number of posts to show:' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'postnum' ); ?>" name="<?php echo $this->get_field_name( 'postnum' ); ?>" type="text" value="<?php echo esc_attr( $postnum ); ?>" />
	</p>
	<?php 
	}
     
// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['postnum'] = ( ! empty( $new_instance['postnum'] ) ) ? strip_tags( $new_instance['postnum'] ) : '';
		return $instance;
	}
} // Class wpb_widget ends here

add_post_type_support( 'page', 'excerpt' );

function my_nav_menu_item_title( $title, $item, $args, $depth ) {
    $pid = $item->object_id;

      $text = get_the_excerpt($pid);
        if($depth > 0){
            $title .= '<span class="excerpt">' . $text . '</span>';
        }
      return $title;
}
add_filter( 'nav_menu_item_title', 'my_nav_menu_item_title', 10, 4 );